Rem
Rem $Header: create_queues.sql 19-jan-2007.13:31:51 chall    Exp $
Rem
Rem create_queues.sql
Rem
Rem Copyright (c) 2007, Oracle.  All rights reserved.  
Rem
Rem    NAME
Rem      create_queues.sql - Creates queues used for this sample.
Rem
Rem      This script creates two queues with payload of type MGW_BASIC_MSG_T:
Rem      MGWUSER.MGW_BASIC_SRC, MGWUSER.MGW_BASIC_DEST.
Rem
Rem    NOTES
Rem      This script assumes that create_users.sql has already been run.
Rem

connect mgwuser/mgwuser
set serveroutput on

-- create queue tables and queues
begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_basic_mc',
                   queue_payload_type => 'sys.mgw_basic_msg_t',
                   multiple_consumers => TRUE);
    dbms_aqadm.create_queue(queue_name =>'mgw_basic_src',
                            queue_table => 'mgw_basic_mc',
                            max_retries => 1000);
    dbms_aqadm.start_queue('mgw_basic_src');
end;
/

begin
    dbms_aqadm.create_queue_table(
                   queue_table => 'mgw_basic_sc',
                   queue_payload_type => 'sys.mgw_basic_msg_t',
                   multiple_consumers => FALSE);
    dbms_aqadm.create_queue(queue_name =>'mgw_basic_dest',
                            queue_table => 'mgw_basic_sc',
                            max_retries => 1000);
    dbms_aqadm.start_queue('mgw_basic_dest');
end;
/
